/*
 * Decompiled with CFR 0.152.
 */
package icyllis.modernui.transition;

import icyllis.modernui.graphics.Rect;
import icyllis.modernui.transition.Transition;
import icyllis.modernui.transition.TransitionValues;
import icyllis.modernui.transition.VisibilityPropagation;
import icyllis.modernui.view.View;
import icyllis.modernui.view.ViewGroup;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class SidePropagation
extends VisibilityPropagation {
    private float mPropagationSpeed = 3.0f;
    private int mSide = 80;

    public void setSide(int side) {
        this.mSide = side;
    }

    public void setPropagationSpeed(float propagationSpeed) {
        if (propagationSpeed == 0.0f) {
            throw new IllegalArgumentException("propagationSpeed may not be 0");
        }
        this.mPropagationSpeed = propagationSpeed;
    }

    @Override
    public long getStartDelay(@Nonnull ViewGroup sceneRoot, @Nonnull Transition transition, @Nullable TransitionValues startValues, @Nullable TransitionValues endValues) {
        int epicenterY;
        int epicenterX;
        TransitionValues positionValues;
        if (startValues == null && endValues == null) {
            return 0L;
        }
        int directionMultiplier = 1;
        Rect epicenter = transition.getEpicenter();
        if (endValues == null || this.getViewVisibility(startValues) == 0) {
            positionValues = startValues;
            directionMultiplier = -1;
        } else {
            positionValues = endValues;
        }
        int viewCenterX = this.getViewX(positionValues);
        int viewCenterY = this.getViewY(positionValues);
        int[] loc = new int[2];
        sceneRoot.getLocationInWindow(loc);
        int left = loc[0] + Math.round(sceneRoot.getTranslationX());
        int top = loc[1] + Math.round(sceneRoot.getTranslationY());
        int right = left + sceneRoot.getWidth();
        int bottom = top + sceneRoot.getHeight();
        if (epicenter != null) {
            epicenterX = epicenter.centerX();
            epicenterY = epicenter.centerY();
        } else {
            epicenterX = (left + right) / 2;
            epicenterY = (top + bottom) / 2;
        }
        float distance = this.distance(sceneRoot, viewCenterX, viewCenterY, epicenterX, epicenterY, left, top, right, bottom);
        float maxDistance = this.getMaxDistance(sceneRoot);
        float distanceFraction = distance / maxDistance;
        long duration = transition.getDuration();
        if (duration < 0L) {
            duration = 300L;
        }
        return Math.round((float)(duration * (long)directionMultiplier) / this.mPropagationSpeed * distanceFraction);
    }

    private int distance(View sceneRoot, int viewX, int viewY, int epicenterX, int epicenterY, int left, int top, int right, int bottom) {
        boolean isRtl;
        int side = this.mSide == 0x800003 ? ((isRtl = sceneRoot.isLayoutRtl()) ? 5 : 3) : (this.mSide == 0x800005 ? ((isRtl = sceneRoot.isLayoutRtl()) ? 3 : 5) : this.mSide);
        return switch (side) {
            case 3 -> right - viewX + Math.abs(epicenterY - viewY);
            case 48 -> bottom - viewY + Math.abs(epicenterX - viewX);
            case 5 -> viewX - left + Math.abs(epicenterY - viewY);
            case 80 -> viewY - top + Math.abs(epicenterX - viewX);
            default -> 0;
        };
    }

    private int getMaxDistance(@Nonnull ViewGroup sceneRoot) {
        return switch (this.mSide) {
            case 3, 5, 0x800003, 0x800005 -> sceneRoot.getWidth();
            default -> sceneRoot.getHeight();
        };
    }
}

